/*
 * Copyright (c) 2022, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.source.tree;

import jdk.internal.javac.PreviewFeature;

/**
 * A case label element that refers to an expression
 * @since 19
 */
@PreviewFeature(feature=PreviewFeature.Feature.SWITCH_PATTERN_MATCHING, reflective=true)
public interface PatternCaseLabelTree extends CaseLabelTree {

    /**
     * The pattern for the case.
     *
     * @return the pattern
     */
    public PatternTree getPattern();

    /**
     * The guard for the case.
     *
     * @return the guard
     */
    ExpressionTree getGuard();

}
