/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.cache.AbstractLocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

public abstract class BaseLocalApplicationProperties
extends AbstractLocalApplicationProperties {
    protected static final String REBOOT_NEEDED_KEY = "rebootNeeded";
    protected static final String UPDATE_CHECK_KEY = "forcedUpdateCheck";
    protected static final String NATIVELIB_DIR_KEY = "nativeLibDir";
    protected static final String INSTALL_DIR_KEY = "installDir";
    protected static final String LAST_ACCESSED_KEY = "lastAccessed";
    protected static final String LAUNCH_COUNT_KEY = "launchCount";
    protected static final String ASK_INSTALL_KEY = "askedInstall";
    protected static final String SHORTCUT_KEY = "locallyInstalled";
    protected static final String EXTENSION_KEY = "extensionInstalled";
    protected static final String JNLP_INSTALLED_KEY = "jnlpInstalled";
    protected static final String INDIRECT_PATH_KEY = "indirectPath";
    protected static final String ASSOCIATION_MIME_KEY = "mime.types.";
    protected static final String REGISTERED_TITLE_KEY = "title";
    protected static final String ASSOCIATION_EXTENSIONS_KEY = "extensions.";
    protected static final String DRAGGED_APPLET_KEY = "draggedApplet";
    protected static final String DOCUMENTBASE_KEY = "documentBase";
    protected static final String CODEBASE_KEY = "codebase";
    protected static final String ORIGINAL_URL_KEY = "originalURL";
    protected static final String MAIN_PUBLISHER_KEY = "mainPublisher";
    protected static final String MAIN_TITLE_KEY = "mainTitle";
    protected Properties _properties;
    private URL _location;
    private String _versionId;
    private boolean _isApplicationDescriptor;
    protected boolean _isShortcutInstalledSystem;

    public BaseLocalApplicationProperties(URL uRL, String string, boolean bl) {
        this._location = uRL;
        this._versionId = string;
        this._isApplicationDescriptor = bl;
        this._isShortcutInstalledSystem = false;
        this._properties = new Properties();
    }

    public void clearMainPublisherAndTitle() {
        this.setMainPublisher(null);
        this.setMainTitle(null);
        try {
            this.store();
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
    }

    public void storeMainPublisherAndTitle(String string, String string2) {
        String string3 = ResourceManager.getMessage("security.dialog.notverified.subject").toUpperCase();
        if (this.getMainPublisher() != null && this.getMainTitle() != null) {
            return;
        }
        if (string == null) {
            string = string3;
        }
        if (string2 == null) {
            string2 = string3;
        }
        this.setMainPublisher(string);
        this.setMainTitle(string2);
        try {
            this.store();
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
    }

    private void setMainPublisher(String string) {
        this.put(MAIN_PUBLISHER_KEY, string);
    }

    public String getMainPublisher() {
        return this.get(MAIN_PUBLISHER_KEY);
    }

    private void setMainTitle(String string) {
        this.put(MAIN_TITLE_KEY, string);
    }

    public String getMainTitle() {
        return this.get(MAIN_TITLE_KEY);
    }

    public void setEnableCustomPreloader(boolean bl) {
        this.put("ssv.enable.custom.preloader", new Boolean(bl).toString());
    }

    public boolean getEnableCustomPreloader() {
        return this.getBoolean("ssv.enable.custom.preloader");
    }

    public URL getLocation() {
        return this._location;
    }

    public String getVersionId() {
        return this._versionId;
    }

    public void setLastAccessed(Date date) {
        this.put(LAST_ACCESSED_KEY, _df.format(date));
    }

    public Date getLastAccessed() {
        return this.getDate(LAST_ACCESSED_KEY);
    }

    public void incrementLaunchCount() {
        int n = this.getLaunchCount();
        this.put(LAUNCH_COUNT_KEY, Integer.toString(++n));
    }

    public int getLaunchCount() {
        return this.getInteger(LAUNCH_COUNT_KEY);
    }

    public void setAskedForInstall(boolean bl) {
        this.put(ASK_INSTALL_KEY, new Boolean(bl).toString());
    }

    public boolean getAskedForInstall() {
        return this.getBoolean(ASK_INSTALL_KEY);
    }

    public void setRebootNeeded(boolean bl) {
        this.put(REBOOT_NEEDED_KEY, new Boolean(bl).toString());
    }

    public boolean isRebootNeeded() {
        return this.getBoolean(REBOOT_NEEDED_KEY);
    }

    public void setDraggedApplet() {
        this.put(DRAGGED_APPLET_KEY, new Boolean(true).toString());
    }

    public boolean isDraggedApplet() {
        return this.getBoolean(DRAGGED_APPLET_KEY);
    }

    public void setDocumentBase(String string) {
        this.put(DOCUMENTBASE_KEY, string);
    }

    public String getDocumentBase() {
        return this.get(DOCUMENTBASE_KEY);
    }

    public void setCodebase(String string) {
        this.put(CODEBASE_KEY, string);
    }

    public String getCodebase() {
        return this.get(CODEBASE_KEY);
    }

    public String getOriginalURL() {
        return this.get(ORIGINAL_URL_KEY);
    }

    public void setOriginalURL(String string) {
        this.put(ORIGINAL_URL_KEY, string);
    }

    public void setShortcutInstalled(boolean bl) {
        this.put(SHORTCUT_KEY, new Boolean(bl).toString());
    }

    public boolean isShortcutInstalled() {
        return this.getBoolean(SHORTCUT_KEY);
    }

    public boolean isShortcutInstalledSystem() {
        return this._isShortcutInstalledSystem;
    }

    public void setExtensionInstalled(boolean bl) {
        this.setShortcutInstalled(false);
        this.put(EXTENSION_KEY, new Boolean(bl).toString());
    }

    public boolean isExtensionInstalled() {
        return this.getBoolean(EXTENSION_KEY) || this.getBoolean(SHORTCUT_KEY);
    }

    public void setJnlpInstalled(boolean bl) {
        this.put(JNLP_INSTALLED_KEY, new Boolean(bl).toString());
    }

    public boolean isJnlpInstalled() {
        return this.getBoolean(JNLP_INSTALLED_KEY);
    }

    public boolean forceUpdateCheck() {
        return this.getBoolean(UPDATE_CHECK_KEY);
    }

    public void setForceUpdateCheck(boolean bl) {
        this.put(UPDATE_CHECK_KEY, new Boolean(bl).toString());
    }

    public boolean isApplicationDescriptor() {
        return this._isApplicationDescriptor;
    }

    public boolean isExtensionDescriptor() {
        return !this._isApplicationDescriptor;
    }

    public String getInstallDirectory() {
        return this.get(INSTALL_DIR_KEY);
    }

    public void setInstallDirectory(String string) {
        this.put(INSTALL_DIR_KEY, string);
    }

    public String getNativeLibDirectory() {
        return this.get(NATIVELIB_DIR_KEY);
    }

    public void setNativeLibDirectory(String string) {
        this.put(NATIVELIB_DIR_KEY, string);
    }

    public String getRegisteredTitle() {
        return this.get(REGISTERED_TITLE_KEY);
    }

    public void setRegisteredTitle(String string) {
        this.put(REGISTERED_TITLE_KEY, string);
    }

    public void setAssociations(AssociationDesc[] associationDescArray) {
        int n = 0;
        if (associationDescArray == null) {
            AssociationDesc[] associationDescArray2 = this.getAssociations();
            if (associationDescArray2 != null) {
                this.put(ASSOCIATION_MIME_KEY + n, null);
                this.put(ASSOCIATION_EXTENSIONS_KEY + n, null);
            }
        } else {
            for (n = 0; n < associationDescArray.length; ++n) {
                this.put(ASSOCIATION_MIME_KEY + n, associationDescArray[n].getMimeType());
                this.put(ASSOCIATION_EXTENSIONS_KEY + n, associationDescArray[n].getExtensions());
            }
            this.put(ASSOCIATION_MIME_KEY + n, null);
            this.put(ASSOCIATION_EXTENSIONS_KEY + n, null);
        }
    }

    public void addAssociation(AssociationDesc associationDesc) {
        AssociationDesc[] associationDescArray;
        AssociationDesc[] associationDescArray2 = this.getAssociations();
        if (associationDescArray2 == null) {
            associationDescArray = new AssociationDesc[1];
        } else {
            associationDescArray = new AssociationDesc[associationDescArray2.length + 1];
            for (int i = 0; i < associationDescArray2.length; ++i) {
                associationDescArray[i] = associationDescArray2[i];
            }
        }
        associationDescArray[i] = associationDesc;
        this.setAssociations(associationDescArray);
    }

    public AssociationDesc[] getAssociations() {
        ArrayList<AssociationDesc> arrayList = new ArrayList<AssociationDesc>();
        int n = 0;
        while (true) {
            String string = this.get(ASSOCIATION_MIME_KEY + n);
            String string2 = this.get(ASSOCIATION_EXTENSIONS_KEY + n);
            if (string == null && string2 == null) break;
            arrayList.add(new AssociationDesc(string2, string, null, null));
            ++n;
        }
        return arrayList.toArray(new AssociationDesc[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, String string2) {
        BaseLocalApplicationProperties baseLocalApplicationProperties = this;
        synchronized (baseLocalApplicationProperties) {
            if (string2 == null) {
                this._properties.remove(string);
            } else {
                this._properties.put(string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String string) {
        BaseLocalApplicationProperties baseLocalApplicationProperties = this;
        synchronized (baseLocalApplicationProperties) {
            return (String)this._properties.get(string);
        }
    }

    public String toString() {
        return "lap key: " + this._location + " contains properties: " + this._properties;
    }
}

