/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.AbstractControllerManager;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.controllers.ICadeController;
import com.badlogic.gdx.controllers.IosController;
import com.badlogic.gdx.utils.Array;
import org.robovm.apple.foundation.Foundation;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.gamecontroller.GCController;
import org.robovm.apple.uikit.UIKeyCommand;
import org.robovm.apple.uikit.UIKeyModifierFlags;
import org.robovm.apple.uikit.UIViewController;
import org.robovm.objc.Selector;
import org.robovm.objc.block.VoidBlock1;

public class IosControllerManager
extends AbstractControllerManager {
    private final Array<ControllerListener> listeners = new Array();
    private boolean initialized = false;
    private ICadeController iCadeController;

    public IosControllerManager() {
        this.listeners.add(new AbstractControllerManager.ManageCurrentControllerListener());
    }

    public static void enableICade(UIViewController controller, Selector action) {
        for (int i = 0; i < "hrufytjnimkplvogaqdcwexz".length(); ++i) {
            controller.addKeyCommand(new UIKeyCommand(Character.toString("hrufytjnimkplvogaqdcwexz".charAt(i)), UIKeyModifierFlags.None, action));
        }
        controller.becomeFirstResponder();
        Gdx.app.log("Controllers", "iCade support activated");
    }

    public static void keyPress(UIKeyCommand sender) {
        IosControllerManager controllerManager = (IosControllerManager)Controllers.managers.get(Gdx.app);
        if (controllerManager != null) {
            controllerManager.handleKeyPressed(sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeyPressed(UIKeyCommand sender) {
        if (this.iCadeController == null) {
            Gdx.app.log("Controllers", "iCade key was pressed, adding iCade controller.");
            this.iCadeController = new ICadeController();
            this.controllers.add(this.iCadeController);
            Array<ControllerListener> array = this.listeners;
            synchronized (array) {
                for (ControllerListener listener : this.listeners) {
                    listener.connected(this.iCadeController);
                }
            }
        }
        this.iCadeController.handleKeyPressed(sender.getInput());
    }

    protected boolean isSupportedController(GCController controller) {
        return controller.getExtendedGamepad() != null || controller.getGamepad() != null;
    }

    @Override
    public Array<Controller> getControllers() {
        this.initializeControllerArray();
        return super.getControllers();
    }

    @Override
    public Controller getCurrentController() {
        this.initializeControllerArray();
        return super.getCurrentController();
    }

    private void initializeControllerArray() {
        if (!this.initialized && Foundation.getMajorSystemVersion() >= 7) {
            this.initialized = true;
            NSArray controllers = GCController.getControllers();
            for (GCController controller : controllers) {
                if (!this.isSupportedController(controller)) continue;
                this.controllers.add(new IosController(controller));
            }
            GCController.Notifications.observeDidConnect((VoidBlock1)new VoidBlock1<GCController>(){

                public void invoke(GCController gcController) {
                    IosControllerManager.this.onControllerConnect(gcController);
                }
            });
            GCController.Notifications.observeDidDisconnect((VoidBlock1)new VoidBlock1<GCController>(){

                public void invoke(GCController gcController) {
                    IosControllerManager.this.onControllerDisconnect(gcController);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onControllerConnect(GCController gcController) {
        if (!this.isSupportedController(gcController)) {
            return;
        }
        boolean alreadyInList = false;
        for (Controller controller : this.controllers) {
            if (!(controller instanceof IosController) || ((IosController)controller).getController() != gcController) continue;
            alreadyInList = true;
            break;
        }
        if (!alreadyInList) {
            IosController iosController = new IosController(gcController);
            this.controllers.add(iosController);
            Array<ControllerListener> array = this.listeners;
            synchronized (array) {
                for (ControllerListener listener : this.listeners) {
                    listener.connected(iosController);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onControllerDisconnect(GCController gcController) {
        IosController oldReference = null;
        for (Controller controller : this.controllers) {
            if (!(controller instanceof IosController) || ((IosController)controller).getController() != gcController) continue;
            oldReference = (IosController)controller;
        }
        if (oldReference != null) {
            this.controllers.removeValue(oldReference, true);
            Array<ControllerListener> array = this.listeners;
            synchronized (array) {
                for (ControllerListener listener : this.listeners) {
                    listener.disconnected(oldReference);
                }
            }
            oldReference.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ControllerListener controllerListener) {
        this.initializeControllerArray();
        Array<ControllerListener> array = this.listeners;
        synchronized (array) {
            if (!this.listeners.contains(controllerListener, true)) {
                this.listeners.add(controllerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ControllerListener controllerListener) {
        Array<ControllerListener> array = this.listeners;
        synchronized (array) {
            this.listeners.removeValue(controllerListener, true);
        }
    }

    @Override
    public Array<ControllerListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearListeners() {
        Array<ControllerListener> array = this.listeners;
        synchronized (array) {
            this.listeners.clear();
            this.listeners.add(new AbstractControllerManager.ManageCurrentControllerListener());
        }
    }
}

