/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.iosrobovm.objectal.ALBuffer;
import com.badlogic.gdx.backends.iosrobovm.objectal.ALChannelSource;
import com.badlogic.gdx.backends.iosrobovm.objectal.ALSource;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALSimpleAudio;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.IntArray;
import org.robovm.apple.foundation.NSArray;

public class IOSSound
implements Sound {
    private ALBuffer soundBuffer;
    private String soundPath;
    private ALChannelSource channel;
    private NSArray<ALSource> sourcePool;
    private IntArray streamIds = new IntArray(8);

    public IOSSound(FileHandle filePath) {
        this.soundPath = filePath.file().getPath().replace('\\', '/');
        this.soundBuffer = OALSimpleAudio.sharedInstance().preloadEffect(this.soundPath);
        this.channel = OALSimpleAudio.sharedInstance().getChannelSource();
        this.sourcePool = this.channel.getSourcePool().getSources();
    }

    @Override
    public long play() {
        return this.play(1.0f, 1.0f, 0.0f, false);
    }

    @Override
    public long play(float volume) {
        return this.play(volume, 1.0f, 0.0f, false);
    }

    @Override
    public long play(float volume, float pitch, float pan) {
        return this.play(volume, pitch, pan, false);
    }

    public long play(float volume, float pitch, float pan, boolean loop) {
        ALSource soundSource;
        if (this.streamIds.size == 8) {
            this.streamIds.pop();
        }
        if ((soundSource = OALSimpleAudio.sharedInstance().playBuffer(this.soundBuffer, volume, pitch, pan, loop)) == null) {
            return -1L;
        }
        if (soundSource.getSourceId() == -1) {
            return -1L;
        }
        this.streamIds.insert(0, soundSource.getSourceId());
        return soundSource.getSourceId();
    }

    @Override
    public long loop() {
        return this.play(1.0f, 1.0f, 0.0f, true);
    }

    @Override
    public long loop(float volume) {
        return this.play(volume, 1.0f, 0.0f, true);
    }

    @Override
    public long loop(float volume, float pitch, float pan) {
        return this.play(volume, pitch, pan, true);
    }

    @Override
    public void stop() {
        for (int i = 0; i < this.streamIds.size; ++i) {
            ALSource source = this.getSoundSource(this.streamIds.get(i));
            if (source == null) continue;
            source.stop();
        }
    }

    @Override
    public void dispose() {
        this.stop();
        OALSimpleAudio.sharedInstance().unloadEffect(this.soundPath);
    }

    @Override
    public void stop(long soundId) {
        ALSource source = this.getSoundSource(soundId);
        if (source != null) {
            source.stop();
        }
    }

    @Override
    public void setLooping(long soundId, boolean looping) {
        ALSource source = this.getSoundSource(soundId);
        if (source != null) {
            source.setLooping(looping);
        }
    }

    @Override
    public void setPitch(long soundId, float pitch) {
        ALSource source = this.getSoundSource(soundId);
        if (source != null) {
            source.setPitch(pitch);
        }
    }

    @Override
    public void setVolume(long soundId, float volume) {
        ALSource source = this.getSoundSource(soundId);
        if (source != null) {
            source.setVolume(volume);
        }
    }

    @Override
    public void setPan(long soundId, float pan, float volume) {
        ALSource source = this.getSoundSource(soundId);
        if (source != null) {
            source.setPan(pan);
            source.setVolume(volume);
        }
    }

    @Override
    public void pause() {
        for (int i = 0; i < this.streamIds.size; ++i) {
            ALSource source = this.getSoundSource(this.streamIds.get(i));
            if (source == null) continue;
            source.setPaused(true);
        }
    }

    @Override
    public void resume() {
        for (int i = 0; i < this.streamIds.size; ++i) {
            ALSource source = this.getSoundSource(this.streamIds.get(i));
            if (source == null) continue;
            source.setPaused(false);
        }
    }

    @Override
    public void pause(long soundId) {
        ALSource source = this.getSoundSource(soundId);
        if (source != null) {
            source.setPaused(true);
        }
    }

    @Override
    public void resume(long soundId) {
        ALSource source = this.getSoundSource(soundId);
        if (source != null) {
            source.setPaused(false);
        }
    }

    private ALSource getSoundSource(long soundId) {
        for (ALSource source : this.sourcePool) {
            if ((long)source.getSourceId() != soundId) continue;
            return source;
        }
        return null;
    }
}

