/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.AbstractGraphics;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.backends.iosrobovm.IOSApplication;
import com.badlogic.gdx.backends.iosrobovm.IOSApplicationConfiguration;
import com.badlogic.gdx.backends.iosrobovm.IOSDevice;
import com.badlogic.gdx.backends.iosrobovm.IOSGLES20;
import com.badlogic.gdx.backends.iosrobovm.IOSGLES30;
import com.badlogic.gdx.backends.iosrobovm.IOSInput;
import com.badlogic.gdx.backends.iosrobovm.IOSScreenBounds;
import com.badlogic.gdx.backends.iosrobovm.IOSUIViewController;
import com.badlogic.gdx.backends.iosrobovm.custom.HWMachine;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.GL31;
import com.badlogic.gdx.graphics.GL32;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.utils.Array;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.glkit.GLKView;
import org.robovm.apple.glkit.GLKViewController;
import org.robovm.apple.glkit.GLKViewControllerDelegate;
import org.robovm.apple.glkit.GLKViewDelegate;
import org.robovm.apple.glkit.GLKViewDrawableColorFormat;
import org.robovm.apple.glkit.GLKViewDrawableDepthFormat;
import org.robovm.apple.glkit.GLKViewDrawableMultisample;
import org.robovm.apple.glkit.GLKViewDrawableStencilFormat;
import org.robovm.apple.opengles.EAGLContext;
import org.robovm.apple.opengles.EAGLRenderingAPI;
import org.robovm.apple.uikit.UIEdgeInsets;
import org.robovm.apple.uikit.UIEvent;
import org.robovm.apple.uikit.UIScreen;
import org.robovm.apple.uikit.UIView;
import org.robovm.objc.annotation.Method;
import org.robovm.rt.bro.annotation.Pointer;

public class IOSGraphics
extends AbstractGraphics {
    private static final String tag = "IOSGraphics";
    IOSApplication app;
    IOSInput input;
    GL20 gl20;
    GL30 gl30;
    IOSScreenBounds screenBounds;
    int safeInsetLeft;
    int safeInsetTop;
    int safeInsetBottom;
    int safeInsetRight;
    long lastFrameTime;
    float deltaTime;
    long framesStart;
    int frames;
    int fps;
    Graphics.BufferFormat bufferFormat;
    String extensions;
    private float ppiX = 0.0f;
    private float ppiY = 0.0f;
    private float ppcX = 0.0f;
    private float ppcY = 0.0f;
    private float density = 1.0f;
    volatile boolean resume = false;
    volatile boolean appPaused;
    private long frameId = -1L;
    private boolean isContinuous = true;
    private boolean isFrameRequested = true;
    IOSApplicationConfiguration config;
    EAGLContext context;
    GLVersion glVersion;
    GLKView view;
    IOSUIViewController viewController;

    public IOSGraphics(IOSApplication app, IOSApplicationConfiguration config, IOSInput input, boolean useGLES30) {
        this.config = config;
        this.screenBounds = app.computeBounds();
        if (useGLES30) {
            this.context = new EAGLContext(EAGLRenderingAPI.OpenGLES3);
            if (this.context != null) {
                this.gl30 = new IOSGLES30();
                this.gl20 = this.gl30;
            } else {
                Gdx.app.log("IOGraphics", "OpenGL ES 3.0 not supported, falling back on 2.0");
            }
        }
        if (this.context == null) {
            this.context = new EAGLContext(EAGLRenderingAPI.OpenGLES2);
            this.gl20 = new IOSGLES20();
            this.gl30 = null;
        }
        IOSViewDelegate viewDelegate = new IOSViewDelegate();
        this.view = new GLKView(new CGRect(0.0, 0.0, (double)this.screenBounds.width, (double)this.screenBounds.height), this.context){

            @Method(selector="touchesBegan:withEvent:")
            public void touchesBegan(@Pointer long touches, UIEvent event) {
                IOSGraphics.this.input.onTouch(touches);
            }

            @Method(selector="touchesCancelled:withEvent:")
            public void touchesCancelled(@Pointer long touches, UIEvent event) {
                IOSGraphics.this.input.onTouch(touches);
            }

            @Method(selector="touchesEnded:withEvent:")
            public void touchesEnded(@Pointer long touches, UIEvent event) {
                IOSGraphics.this.input.onTouch(touches);
            }

            @Method(selector="touchesMoved:withEvent:")
            public void touchesMoved(@Pointer long touches, UIEvent event) {
                IOSGraphics.this.input.onTouch(touches);
            }

            public void draw(CGRect rect) {
                IOSGraphics.this.draw(this, rect);
            }
        };
        this.view.setDelegate((GLKViewDelegate)viewDelegate);
        this.view.setDrawableColorFormat(config.colorFormat);
        this.view.setDrawableDepthFormat(config.depthFormat);
        this.view.setDrawableStencilFormat(config.stencilFormat);
        this.view.setDrawableMultisample(config.multisample);
        this.view.setMultipleTouchEnabled(true);
        this.viewController = app.createUIViewController(this);
        this.viewController.setView((UIView)this.view);
        this.viewController.setDelegate(viewDelegate);
        int preferredFps = config.preferredFramesPerSecond == 0 ? (int)UIScreen.getMainScreen().getMaximumFramesPerSecond() : config.preferredFramesPerSecond;
        this.viewController.setPreferredFramesPerSecond(preferredFps);
        this.app = app;
        this.input = input;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int depth = 0;
        int stencil = 0;
        int samples = 0;
        if (config.colorFormat == GLKViewDrawableColorFormat.RGB565) {
            r = 5;
            g = 6;
            b = 5;
            a = 0;
        } else {
            a = 8;
            b = 8;
            g = 8;
            r = 8;
        }
        depth = config.depthFormat == GLKViewDrawableDepthFormat._16 ? 16 : (config.depthFormat == GLKViewDrawableDepthFormat._24 ? 24 : 0);
        if (config.stencilFormat == GLKViewDrawableStencilFormat._8) {
            stencil = 8;
        }
        if (config.multisample == GLKViewDrawableMultisample._4X) {
            samples = 4;
        }
        this.bufferFormat = new Graphics.BufferFormat(r, g, b, a, depth, stencil, samples, false);
        String machineString = HWMachine.getMachineString();
        IOSDevice device = config.knownDevices.get(machineString);
        if (device == null) {
            app.error(tag, "Machine ID: " + machineString + " not found, please report to libGDX");
        }
        int ppi = device != null ? device.ppi : app.guessUnknownPpi();
        this.density = (float)ppi / 160.0f;
        this.ppiX = ppi;
        this.ppiY = ppi;
        this.ppcX = this.ppiX / 2.54f;
        this.ppcY = this.ppiY / 2.54f;
        app.debug(tag, "Display: ppi=" + ppi + ", density=" + this.density);
        this.framesStart = this.lastFrameTime = System.nanoTime();
        this.makeCurrent();
        this.gl20.glViewport(0, 0, this.screenBounds.backBufferWidth, this.screenBounds.backBufferHeight);
        String versionString = this.gl20.glGetString(7938);
        String vendorString = this.gl20.glGetString(7936);
        String rendererString = this.gl20.glGetString(7937);
        this.glVersion = new GLVersion(Application.ApplicationType.iOS, versionString, vendorString, rendererString);
        this.appPaused = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Array<LifecycleListener> listeners;
        if (!this.appPaused) {
            return;
        }
        this.appPaused = false;
        Array<LifecycleListener> array = listeners = this.app.lifecycleListeners;
        synchronized (array) {
            for (LifecycleListener listener : listeners) {
                listener.resume();
            }
        }
        this.resume = true;
        this.app.listener.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Array<LifecycleListener> listeners;
        if (this.appPaused) {
            return;
        }
        this.appPaused = true;
        Array<LifecycleListener> array = listeners = this.app.lifecycleListeners;
        synchronized (array) {
            for (LifecycleListener listener : listeners) {
                listener.pause();
            }
        }
        this.app.listener.pause();
    }

    public void draw(GLKView view, CGRect rect) {
        this.makeCurrent();
        this.gl20.glViewport(IOSGLES20.x, IOSGLES20.y, IOSGLES20.width, IOSGLES20.height);
        if (this.appPaused) {
            return;
        }
        long time = System.nanoTime();
        if (!this.resume) {
            this.deltaTime = (float)(time - this.lastFrameTime) / 1.0E9f;
        } else {
            this.resume = false;
            this.deltaTime = 0.0f;
        }
        this.lastFrameTime = time;
        ++this.frames;
        if (time - this.framesStart >= 1000000000L) {
            this.framesStart = time;
            this.fps = this.frames;
            this.frames = 0;
        }
        this.input.processEvents();
        ++this.frameId;
        this.app.listener.render();
    }

    void makeCurrent() {
        EAGLContext.setCurrentContext((EAGLContext)this.context);
    }

    public void update(GLKViewController controller) {
        this.makeCurrent();
        this.app.processRunnables();
        if (!this.isContinuous && !this.isFrameRequested) {
            this.viewController.setPaused(true);
        }
        this.isFrameRequested = false;
    }

    public void willPause(GLKViewController controller, boolean pause) {
    }

    @Override
    public GL20 getGL20() {
        return this.gl20;
    }

    @Override
    public void setGL20(GL20 gl20) {
        this.gl20 = gl20;
        if (this.gl30 == null) {
            Gdx.gl = gl20;
            Gdx.gl20 = gl20;
        }
    }

    @Override
    public boolean isGL30Available() {
        return this.gl30 != null;
    }

    @Override
    public GL30 getGL30() {
        return this.gl30;
    }

    @Override
    public void setGL30(GL30 gl30) {
        this.gl30 = gl30;
        if (gl30 != null) {
            Gdx.gl = this.gl20 = gl30;
            Gdx.gl20 = this.gl20;
            Gdx.gl30 = gl30;
        }
    }

    @Override
    public boolean isGL31Available() {
        return false;
    }

    @Override
    public GL31 getGL31() {
        return null;
    }

    @Override
    public void setGL31(GL31 gl31) {
    }

    @Override
    public boolean isGL32Available() {
        return false;
    }

    @Override
    public GL32 getGL32() {
        return null;
    }

    @Override
    public void setGL32(GL32 gl32) {
    }

    @Override
    public int getWidth() {
        if (this.config.hdpiMode == HdpiMode.Pixels) {
            return this.getBackBufferWidth();
        }
        return this.screenBounds.width;
    }

    @Override
    public int getHeight() {
        if (this.config.hdpiMode == HdpiMode.Pixels) {
            return this.getBackBufferHeight();
        }
        return this.screenBounds.height;
    }

    @Override
    public int getBackBufferWidth() {
        return this.screenBounds.backBufferWidth;
    }

    @Override
    public int getBackBufferHeight() {
        return this.screenBounds.backBufferHeight;
    }

    @Override
    public float getBackBufferScale() {
        return this.app.pixelsPerPoint;
    }

    @Override
    public float getDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public int getFramesPerSecond() {
        return this.fps;
    }

    @Override
    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.iOSGL;
    }

    @Override
    public GLVersion getGLVersion() {
        return this.glVersion;
    }

    @Override
    public float getPpiX() {
        return this.ppiX;
    }

    @Override
    public float getPpiY() {
        return this.ppiY;
    }

    @Override
    public float getPpcX() {
        return this.ppcX;
    }

    @Override
    public float getPpcY() {
        return this.ppcY;
    }

    @Override
    public float getDensity() {
        return this.density;
    }

    @Override
    public boolean supportsDisplayModeChange() {
        return false;
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[]{this.getDisplayMode()};
    }

    @Override
    public Graphics.DisplayMode getDisplayMode() {
        return new IOSDisplayMode(this.getWidth(), this.getHeight(), (int)this.viewController.getPreferredFramesPerSecond(), this.bufferFormat.r + this.bufferFormat.g + this.bufferFormat.b + this.bufferFormat.a);
    }

    @Override
    public Graphics.Monitor getPrimaryMonitor() {
        return new IOSMonitor(0, 0, "Primary Monitor");
    }

    @Override
    public Graphics.Monitor getMonitor() {
        return this.getPrimaryMonitor();
    }

    @Override
    public Graphics.Monitor[] getMonitors() {
        return new Graphics.Monitor[]{this.getPrimaryMonitor()};
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        return this.getDisplayModes();
    }

    @Override
    public Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        return this.getDisplayMode();
    }

    protected void updateSafeInsets() {
        this.safeInsetTop = 0;
        this.safeInsetLeft = 0;
        this.safeInsetRight = 0;
        this.safeInsetBottom = 0;
        UIEdgeInsets edgeInsets = this.viewController.getView().getSafeAreaInsets();
        this.safeInsetTop = (int)edgeInsets.getTop();
        this.safeInsetLeft = (int)edgeInsets.getLeft();
        this.safeInsetRight = (int)edgeInsets.getRight();
        this.safeInsetBottom = (int)edgeInsets.getBottom();
        if (this.config.hdpiMode == HdpiMode.Pixels) {
            this.safeInsetTop = (int)((float)this.safeInsetTop * this.app.pixelsPerPoint);
            this.safeInsetLeft = (int)((float)this.safeInsetLeft * this.app.pixelsPerPoint);
            this.safeInsetRight = (int)((float)this.safeInsetRight * this.app.pixelsPerPoint);
            this.safeInsetBottom = (int)((float)this.safeInsetBottom * this.app.pixelsPerPoint);
        }
    }

    @Override
    public int getSafeInsetLeft() {
        return this.safeInsetLeft;
    }

    @Override
    public int getSafeInsetTop() {
        return this.safeInsetTop;
    }

    @Override
    public int getSafeInsetBottom() {
        return this.safeInsetBottom;
    }

    @Override
    public int getSafeInsetRight() {
        return this.safeInsetRight;
    }

    @Override
    public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
        return false;
    }

    @Override
    public boolean setWindowedMode(int width, int height) {
        return false;
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void setUndecorated(boolean undecorated) {
    }

    @Override
    public void setResizable(boolean resizable) {
    }

    @Override
    public void setVSync(boolean vsync) {
    }

    @Override
    public void setForegroundFPS(int fps) {
        this.viewController.setPreferredFramesPerSecond(fps);
    }

    @Override
    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    @Override
    public boolean supportsExtension(String extension) {
        if (this.extensions == null) {
            this.extensions = Gdx.gl.glGetString(7939);
        }
        return this.extensions.contains(extension);
    }

    @Override
    public void setContinuousRendering(boolean isContinuous) {
        if (isContinuous != this.isContinuous) {
            this.isContinuous = isContinuous;
            if (isContinuous) {
                this.viewController.setPaused(false);
            }
        }
    }

    @Override
    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    @Override
    public void requestRendering() {
        this.isFrameRequested = true;
        if (!this.isContinuous) {
            this.viewController.setPaused(false);
        }
    }

    @Override
    public boolean isFullscreen() {
        return true;
    }

    @Override
    public long getFrameId() {
        return this.frameId;
    }

    @Override
    public Cursor newCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        return null;
    }

    @Override
    public void setCursor(Cursor cursor) {
    }

    @Override
    public void setSystemCursor(Cursor.SystemCursor systemCursor) {
    }

    private class IOSMonitor
    extends Graphics.Monitor {
        protected IOSMonitor(int virtualX, int virtualY, String name) {
            super(virtualX, virtualY, name);
        }
    }

    private class IOSDisplayMode
    extends Graphics.DisplayMode {
        protected IOSDisplayMode(int width, int height, int refreshRate, int bitsPerPixel) {
            super(width, height, refreshRate, bitsPerPixel);
        }
    }

    private class IOSViewDelegate
    extends NSObject
    implements GLKViewDelegate,
    GLKViewControllerDelegate {
        private IOSViewDelegate() {
        }

        public void update(GLKViewController controller) {
            IOSGraphics.this.update(controller);
        }

        public void willPause(GLKViewController controller, boolean pause) {
            IOSGraphics.this.willPause(controller, pause);
        }

        public void draw(GLKView view, CGRect rect) {
            IOSGraphics.this.draw(view, rect);
        }
    }
}

