/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.AbstractInput;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.iosrobovm.IOSApplication;
import com.badlogic.gdx.backends.iosrobovm.IOSApplicationConfiguration;
import com.badlogic.gdx.backends.iosrobovm.IOSHaptics;
import com.badlogic.gdx.backends.iosrobovm.IOSInput;
import com.badlogic.gdx.backends.iosrobovm.IOSScreenBounds;
import com.badlogic.gdx.backends.iosrobovm.custom.UIAcceleration;
import com.badlogic.gdx.backends.iosrobovm.custom.UIAccelerometer;
import com.badlogic.gdx.backends.iosrobovm.custom.UIAccelerometerDelegate;
import com.badlogic.gdx.backends.iosrobovm.custom.UIAccelerometerDelegateAdapter;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import java.lang.reflect.Field;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.Foundation;
import org.robovm.apple.foundation.NSExtensions;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.gamecontroller.GCKeyboard;
import org.robovm.apple.uikit.UIAlertAction;
import org.robovm.apple.uikit.UIAlertActionStyle;
import org.robovm.apple.uikit.UIAlertController;
import org.robovm.apple.uikit.UIAlertControllerStyle;
import org.robovm.apple.uikit.UIForceTouchCapability;
import org.robovm.apple.uikit.UIKey;
import org.robovm.apple.uikit.UIKeyboardHIDUsage;
import org.robovm.apple.uikit.UIKeyboardType;
import org.robovm.apple.uikit.UIReturnKeyType;
import org.robovm.apple.uikit.UIScreen;
import org.robovm.apple.uikit.UITextAutocapitalizationType;
import org.robovm.apple.uikit.UITextAutocorrectionType;
import org.robovm.apple.uikit.UITextField;
import org.robovm.apple.uikit.UITextFieldDelegate;
import org.robovm.apple.uikit.UITextFieldDelegateAdapter;
import org.robovm.apple.uikit.UITextSpellCheckingType;
import org.robovm.apple.uikit.UITouch;
import org.robovm.apple.uikit.UITouchPhase;
import org.robovm.apple.uikit.UIView;
import org.robovm.apple.uikit.UIViewController;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.VM;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;

public class DefaultIOSInput
extends AbstractInput
implements IOSInput {
    static final int MAX_TOUCHES = 20;
    private static final int POINTER_NOT_FOUND = -1;
    private static final NSObjectWrapper<UITouch> UI_TOUCH_WRAPPER = new NSObjectWrapper<UITouch>(UITouch.class);
    static final NSObjectWrapper<UIAcceleration> UI_ACCELERATION_WRAPPER = new NSObjectWrapper<UIAcceleration>(UIAcceleration.class);
    IOSApplication app;
    IOSApplicationConfiguration config;
    int[] deltaX = new int[20];
    int[] deltaY = new int[20];
    int[] touchX = new int[20];
    int[] touchY = new int[20];
    float[] pressures = new float[20];
    boolean pressureSupported;
    long[] touchDown = new long[20];
    int numTouched = 0;
    boolean justTouched = false;
    Pool<TouchEvent> touchEventPool = new Pool<TouchEvent>(){

        @Override
        protected TouchEvent newObject() {
            return new TouchEvent();
        }
    };
    Array<TouchEvent> touchEvents = new Array();
    private final Pool<KeyEvent> keyEventPool = new Pool<KeyEvent>(16, 1000){

        @Override
        protected KeyEvent newObject() {
            return new KeyEvent();
        }
    };
    private final Array<KeyEvent> keyEvents = new Array();
    private long currentEventTimeStamp = 0L;
    float[] acceleration = new float[3];
    float[] rotation = new float[3];
    float[] R = new float[9];
    InputProcessor inputProcessor = null;
    private IOSHaptics haptics;
    protected UIAccelerometerDelegate accelerometerDelegate;
    boolean compassSupported;
    boolean keyboardCloseOnReturn;
    boolean softkeyboardActive = false;
    private boolean hadHardwareKeyEvent = false;
    private UITextField textfield = null;
    private final UITextFieldDelegate textDelegate = new UITextFieldDelegateAdapter(){

        public boolean shouldChangeCharacters(UITextField textField, NSRange range, String string) {
            int i = 0;
            while ((long)i < range.getLength()) {
                DefaultIOSInput.this.inputProcessor.keyTyped('\b');
                ++i;
            }
            if (string.isEmpty()) {
                if (range.getLength() > 0L) {
                    Gdx.graphics.requestRendering();
                }
                return false;
            }
            char[] chars = new char[string.length()];
            string.getChars(0, string.length(), chars, 0);
            for (int i2 = 0; i2 < chars.length; ++i2) {
                DefaultIOSInput.this.inputProcessor.keyTyped(chars[i2]);
            }
            Gdx.graphics.requestRendering();
            return true;
        }

        public boolean shouldEndEditing(UITextField textField) {
            textField.setText("x");
            Gdx.graphics.requestRendering();
            return true;
        }

        public boolean shouldReturn(UITextField textField) {
            if (DefaultIOSInput.this.keyboardCloseOnReturn) {
                DefaultIOSInput.this.setOnscreenKeyboardVisible(false);
            }
            DefaultIOSInput.this.inputProcessor.keyDown(66);
            DefaultIOSInput.this.inputProcessor.keyTyped('\r');
            Gdx.graphics.requestRendering();
            return false;
        }
    };

    public DefaultIOSInput(IOSApplication app) {
        this.app = app;
        this.config = app.config;
        this.keyboardCloseOnReturn = app.config.keyboardCloseOnReturn;
    }

    @Override
    public void setupPeripherals() {
        this.setupAccelerometer();
        this.setupCompass();
        this.setupHaptics();
        this.setupPressure();
    }

    protected void setupCompass() {
        if (this.config.useCompass) {
            // empty if block
        }
    }

    protected void setupAccelerometer() {
        if (this.config.useAccelerometer) {
            this.accelerometerDelegate = new UIAccelerometerDelegateAdapter(){

                @Method(selector="accelerometer:didAccelerate:")
                public void didAccelerate(UIAccelerometer accelerometer, @Pointer long valuesPtr) {
                    UIAcceleration values = UI_ACCELERATION_WRAPPER.wrap(valuesPtr);
                    float x = (float)values.getX() * 10.0f;
                    float y = (float)values.getY() * 10.0f;
                    float z = (float)values.getZ() * 10.0f;
                    DefaultIOSInput.this.acceleration[0] = -x;
                    DefaultIOSInput.this.acceleration[1] = -y;
                    DefaultIOSInput.this.acceleration[2] = -z;
                }
            };
            UIAccelerometer.getSharedAccelerometer().setDelegate(this.accelerometerDelegate);
            UIAccelerometer.getSharedAccelerometer().setUpdateInterval(this.config.accelerometerUpdate);
        }
    }

    protected void setupHaptics() {
        this.haptics = new IOSHaptics(this.config.useHaptics);
    }

    protected void setupPressure() {
        UIForceTouchCapability forceTouchCapability = UIScreen.getMainScreen().getTraitCollection().getForceTouchCapability();
        this.pressureSupported = forceTouchCapability == UIForceTouchCapability.Available;
    }

    @Override
    public float getAccelerometerX() {
        return this.acceleration[0];
    }

    @Override
    public float getAccelerometerY() {
        return this.acceleration[1];
    }

    @Override
    public float getAccelerometerZ() {
        return this.acceleration[2];
    }

    @Override
    public float getAzimuth() {
        if (!this.compassSupported) {
            return 0.0f;
        }
        return this.rotation[0];
    }

    @Override
    public float getPitch() {
        if (!this.compassSupported) {
            return 0.0f;
        }
        return this.rotation[1];
    }

    @Override
    public float getRoll() {
        if (!this.compassSupported) {
            return 0.0f;
        }
        return this.rotation[2];
    }

    @Override
    public void getRotationMatrix(float[] matrix) {
        if (matrix.length != 9) {
            return;
        }
    }

    @Override
    public int getMaxPointers() {
        return 20;
    }

    @Override
    public int getX() {
        return this.touchX[0];
    }

    @Override
    public int getX(int pointer) {
        return this.touchX[pointer];
    }

    @Override
    public int getDeltaX() {
        return this.deltaX[0];
    }

    @Override
    public int getDeltaX(int pointer) {
        return this.deltaX[pointer];
    }

    @Override
    public int getY() {
        return this.touchY[0];
    }

    @Override
    public int getY(int pointer) {
        return this.touchY[pointer];
    }

    @Override
    public int getDeltaY() {
        return this.deltaY[0];
    }

    @Override
    public int getDeltaY(int pointer) {
        return this.deltaY[pointer];
    }

    @Override
    public boolean isTouched() {
        for (int pointer = 0; pointer < 20; ++pointer) {
            if (this.touchDown[pointer] == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean justTouched() {
        return this.justTouched;
    }

    @Override
    public boolean isTouched(int pointer) {
        return this.touchDown[pointer] != 0L;
    }

    @Override
    public float getPressure() {
        return this.pressures[0];
    }

    @Override
    public float getPressure(int pointer) {
        return this.pressures[pointer];
    }

    @Override
    public boolean isButtonPressed(int button) {
        return button == 0 && this.numTouched > 0;
    }

    @Override
    public boolean isButtonJustPressed(int button) {
        return button == 0 && this.justTouched;
    }

    @Override
    public void getTextInput(Input.TextInputListener listener, String title, String text, String hint) {
        this.getTextInput(listener, title, text, hint, Input.OnscreenKeyboardType.Default);
    }

    @Override
    public void getTextInput(Input.TextInputListener listener, String title, String text, String hint, Input.OnscreenKeyboardType type) {
        UIAlertController uiAlertController = this.buildUIAlertController(listener, title, text, hint, type);
        this.app.getUIViewController().presentViewController((UIViewController)uiAlertController, true, null);
    }

    @Override
    public void setOnscreenKeyboardVisible(boolean visible) {
        this.setOnscreenKeyboardVisible(visible, Input.OnscreenKeyboardType.Default);
    }

    @Override
    public void setOnscreenKeyboardVisible(boolean visible, Input.OnscreenKeyboardType type) {
        if (this.textfield == null) {
            this.createDefaultTextField();
        }
        this.softkeyboardActive = visible;
        if (visible) {
            if (type == null) {
                type = Input.OnscreenKeyboardType.Default;
            }
            this.textfield.setKeyboardType(this.getIosInputType(type));
            this.textfield.reloadInputViews();
            this.textfield.becomeFirstResponder();
            this.textfield.setDelegate(this.textDelegate);
        } else {
            this.textfield.resignFirstResponder();
        }
    }

    protected UIKeyboardType getIosInputType(Input.OnscreenKeyboardType type) {
        UIKeyboardType preferredInputType;
        switch (type) {
            case NumberPad: {
                preferredInputType = UIKeyboardType.NumberPad;
                break;
            }
            case PhonePad: {
                preferredInputType = UIKeyboardType.PhonePad;
                break;
            }
            case Email: {
                preferredInputType = UIKeyboardType.EmailAddress;
                break;
            }
            case URI: {
                preferredInputType = UIKeyboardType.URL;
                break;
            }
            default: {
                preferredInputType = UIKeyboardType.Default;
            }
        }
        return preferredInputType;
    }

    public void setKeyboardCloseOnReturnKey(boolean shouldClose) {
        this.keyboardCloseOnReturn = shouldClose;
    }

    public UITextField getKeyboardTextField() {
        if (this.textfield == null) {
            this.createDefaultTextField();
        }
        return this.textfield;
    }

    private void createDefaultTextField() {
        this.textfield = new UITextField(new CGRect(10.0, 10.0, 100.0, 50.0));
        this.textfield.setKeyboardType(UIKeyboardType.Default);
        this.textfield.setReturnKeyType(UIReturnKeyType.Done);
        this.textfield.setAutocapitalizationType(UITextAutocapitalizationType.None);
        this.textfield.setAutocorrectionType(UITextAutocorrectionType.No);
        this.textfield.setSpellCheckingType(UITextSpellCheckingType.No);
        this.textfield.setHidden(true);
        this.textfield.setText("x");
        this.app.getUIViewController().getView().addSubview((UIView)this.textfield);
    }

    private UIAlertController buildUIAlertController(final Input.TextInputListener listener, String title, final String text, final String placeholder, final Input.OnscreenKeyboardType type) {
        final UIAlertController uiAlertController = new UIAlertController(title, text, UIAlertControllerStyle.Alert);
        uiAlertController.addTextField((VoidBlock1)new VoidBlock1<UITextField>(){

            public void invoke(UITextField uiTextField) {
                uiTextField.setPlaceholder(placeholder);
                uiTextField.setText(text);
                uiTextField.setKeyboardType(DefaultIOSInput.this.getIosInputType(type));
                if (type == Input.OnscreenKeyboardType.Password) {
                    uiTextField.setSecureTextEntry(true);
                }
            }
        });
        uiAlertController.addAction(new UIAlertAction("Ok", UIAlertActionStyle.Default, (VoidBlock1)new VoidBlock1<UIAlertAction>(){

            public void invoke(UIAlertAction uiAlertAction) {
                UITextField textField = (UITextField)uiAlertController.getTextFields().get(0);
                listener.input(textField.getText());
            }
        }));
        uiAlertController.addAction(new UIAlertAction("Cancel", UIAlertActionStyle.Cancel, (VoidBlock1)new VoidBlock1<UIAlertAction>(){

            public void invoke(UIAlertAction uiAlertAction) {
                listener.canceled();
            }
        }));
        return uiAlertController;
    }

    @Override
    public void vibrate(int milliseconds) {
        this.haptics.vibrate(milliseconds, true);
    }

    @Override
    public void vibrate(int milliseconds, boolean fallback) {
        this.haptics.vibrate(milliseconds, fallback);
    }

    @Override
    public void vibrate(int milliseconds, int amplitude, boolean fallback) {
        this.haptics.vibrate(milliseconds, amplitude, fallback);
    }

    @Override
    public void vibrate(Input.VibrationType vibrationType) {
        this.haptics.vibrate(vibrationType);
    }

    @Override
    public long getCurrentEventTime() {
        return this.currentEventTimeStamp;
    }

    @Override
    public void setInputProcessor(InputProcessor processor) {
        this.inputProcessor = processor;
    }

    @Override
    public InputProcessor getInputProcessor() {
        return this.inputProcessor;
    }

    @Override
    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        if (peripheral == Input.Peripheral.Accelerometer && this.config.useAccelerometer) {
            return true;
        }
        if (peripheral == Input.Peripheral.MultitouchScreen) {
            return true;
        }
        if (peripheral == Input.Peripheral.Vibrator) {
            return this.haptics.isVibratorSupported();
        }
        if (peripheral == Input.Peripheral.HapticFeedback) {
            return this.haptics.isHapticsSupported();
        }
        if (peripheral == Input.Peripheral.Compass) {
            return this.compassSupported;
        }
        if (peripheral == Input.Peripheral.OnscreenKeyboard) {
            return true;
        }
        if (peripheral == Input.Peripheral.Pressure) {
            return this.pressureSupported;
        }
        if (peripheral == Input.Peripheral.HardwareKeyboard) {
            return Foundation.getMajorSystemVersion() >= 14 ? GCKeyboard.getCoalescedKeyboard() != null : this.hadHardwareKeyEvent;
        }
        return false;
    }

    @Override
    public int getRotation() {
        switch (this.app.uiApp.getStatusBarOrientation()) {
            case LandscapeLeft: {
                return 270;
            }
            case PortraitUpsideDown: {
                return 180;
            }
            case LandscapeRight: {
                return 90;
            }
        }
        return 0;
    }

    @Override
    public Input.Orientation getNativeOrientation() {
        return Input.Orientation.Portrait;
    }

    @Override
    public void setCursorCatched(boolean catched) {
    }

    @Override
    public boolean isCursorCatched() {
        return false;
    }

    @Override
    public void setCursorPosition(int x, int y) {
    }

    @Override
    public void onTouch(long touches) {
        this.toTouchEvents(touches);
        Gdx.graphics.requestRendering();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onKey(UIKey key, boolean down) {
        if (key == null) {
            return false;
        }
        int keyCode = this.getGdxKeyCode(key);
        if (keyCode != 0) {
            Array<KeyEvent> array = this.keyEvents;
            synchronized (array) {
                long timeStamp;
                this.hadHardwareKeyEvent = true;
                KeyEvent event = this.keyEventPool.obtain();
                event.timeStamp = timeStamp = System.nanoTime();
                event.keyChar = '\u0000';
                event.keyCode = keyCode;
                event.type = down ? 0 : 1;
                this.keyEvents.add(event);
                if (!down) {
                    int character;
                    switch (keyCode) {
                        case 67: {
                            character = 8;
                            break;
                        }
                        case 112: {
                            character = 127;
                            break;
                        }
                        case 66: {
                            character = 13;
                            break;
                        }
                        default: {
                            String characters = key.getCharacters();
                            int n = character = characters != null && characters.length() == 1 ? (int)characters.charAt(0) : 0;
                        }
                    }
                    if (character >= 0) {
                        event = this.keyEventPool.obtain();
                        event.timeStamp = timeStamp;
                        event.type = 2;
                        event.keyCode = keyCode;
                        event.keyChar = (char)character;
                        this.keyEvents.add(event);
                    }
                    if (this.pressedKeys[keyCode]) {
                        --this.pressedKeyCount;
                        this.pressedKeys[keyCode] = false;
                    }
                } else if (!this.pressedKeys[event.keyCode]) {
                    ++this.pressedKeyCount;
                    this.pressedKeys[event.keyCode] = true;
                }
            }
        }
        return this.isCatchKey(keyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvents() {
        Array<Object> array = this.touchEvents;
        synchronized (array) {
            this.justTouched = false;
            for (TouchEvent event : this.touchEvents) {
                this.currentEventTimeStamp = event.timestamp;
                switch (event.phase) {
                    case Began: {
                        if (this.inputProcessor != null) {
                            this.inputProcessor.touchDown(event.x, event.y, event.pointer, 0);
                        }
                        if (this.numTouched < 1) break;
                        this.justTouched = true;
                        break;
                    }
                    case Ended: {
                        if (this.inputProcessor == null) break;
                        this.inputProcessor.touchUp(event.x, event.y, event.pointer, 0);
                        break;
                    }
                    case Cancelled: {
                        if (this.inputProcessor == null) break;
                        this.inputProcessor.touchCancelled(event.x, event.y, event.pointer, 0);
                        break;
                    }
                    case Moved: 
                    case Stationary: {
                        if (this.inputProcessor == null) break;
                        this.inputProcessor.touchDragged(event.x, event.y, event.pointer);
                    }
                }
            }
            this.touchEventPool.freeAll(this.touchEvents);
            this.touchEvents.clear();
        }
        array = this.keyEvents;
        synchronized (array) {
            if (this.keyJustPressed) {
                this.keyJustPressed = false;
                for (int i = 0; i < this.justPressedKeys.length; ++i) {
                    this.justPressedKeys[i] = false;
                }
            }
            for (KeyEvent e : this.keyEvents) {
                this.currentEventTimeStamp = e.timeStamp;
                switch (e.type) {
                    case 0: {
                        if (this.inputProcessor != null) {
                            this.inputProcessor.keyDown(e.keyCode);
                        }
                        this.keyJustPressed = true;
                        this.justPressedKeys[e.keyCode] = true;
                        break;
                    }
                    case 1: {
                        if (this.inputProcessor == null) break;
                        this.inputProcessor.keyUp(e.keyCode);
                        break;
                    }
                    case 2: {
                        if (this.softkeyboardActive || this.inputProcessor == null) break;
                        this.inputProcessor.keyTyped(e.keyChar);
                    }
                }
            }
            this.keyEventPool.freeAll(this.keyEvents);
            this.keyEvents.clear();
        }
    }

    private int getFreePointer() {
        for (int i = 0; i < this.touchDown.length; ++i) {
            if (this.touchDown[i] != 0L) continue;
            return i;
        }
        throw new GdxRuntimeException("Couldn't find free pointer id!");
    }

    private int findPointer(UITouch touch) {
        long ptr = touch.getHandle();
        for (int i = 0; i < this.touchDown.length; ++i) {
            if (this.touchDown[i] != ptr) continue;
            return i;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.touchDown.length; ++i) {
            sb.append(i + ":" + this.touchDown[i] + " ");
        }
        Gdx.app.error("IOSInput", "Pointer ID lookup failed: " + ptr + ", " + sb.toString());
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toTouchEvents(long touches) {
        long array = NSSetExtensions.allObjects(touches);
        int length = (int)NSArrayExtensions.count(array);
        IOSScreenBounds screenBounds = this.app.getScreenBounds();
        for (int i = 0; i < length; ++i) {
            long touchHandle = NSArrayExtensions.objectAtIndex$(array, i);
            UITouch touch = UI_TOUCH_WRAPPER.wrap(touchHandle);
            CGPoint loc = touch.getLocationInView((UIView)this.app.graphics.view);
            int locX = (int)(loc.getX() - (double)screenBounds.x);
            int locY = (int)(loc.getY() - (double)screenBounds.y);
            if (this.config.hdpiMode == HdpiMode.Pixels) {
                locX = (int)((float)locX * this.app.pixelsPerPoint);
                locY = (int)((float)locY * this.app.pixelsPerPoint);
            }
            float pressure = 1.0f;
            if (this.pressureSupported) {
                pressure = (float)touch.getForce();
            }
            Array<TouchEvent> array2 = this.touchEvents;
            synchronized (array2) {
                UITouchPhase phase = touch.getPhase();
                TouchEvent event = this.touchEventPool.obtain();
                event.x = locX;
                event.y = locY;
                event.phase = phase;
                event.timestamp = (long)(touch.getTimestamp() * 1.0E9);
                if (phase == UITouchPhase.Began) {
                    event.pointer = this.getFreePointer();
                    this.touchDown[event.pointer] = touch.getHandle();
                    this.touchX[event.pointer] = event.x;
                    this.touchY[event.pointer] = event.y;
                    this.deltaX[event.pointer] = 0;
                    this.deltaY[event.pointer] = 0;
                    this.pressures[event.pointer] = pressure;
                    ++this.numTouched;
                } else if (phase == UITouchPhase.Moved || phase == UITouchPhase.Stationary) {
                    event.pointer = this.findPointer(touch);
                    if (event.pointer != -1) {
                        this.deltaX[event.pointer] = event.x - this.touchX[event.pointer];
                        this.deltaY[event.pointer] = event.y - this.touchY[event.pointer];
                        this.touchX[event.pointer] = event.x;
                        this.touchY[event.pointer] = event.y;
                        this.pressures[event.pointer] = pressure;
                    }
                } else if (phase == UITouchPhase.Cancelled || phase == UITouchPhase.Ended) {
                    event.pointer = this.findPointer(touch);
                    if (event.pointer != -1) {
                        this.touchDown[event.pointer] = 0L;
                        this.touchX[event.pointer] = event.x;
                        this.touchY[event.pointer] = event.y;
                        this.deltaX[event.pointer] = 0;
                        this.deltaY[event.pointer] = 0;
                        this.pressures[event.pointer] = 0.0f;
                        --this.numTouched;
                    }
                }
                if (event.pointer != -1) {
                    this.touchEvents.add(event);
                } else {
                    this.touchEventPool.free(event);
                }
                continue;
            }
        }
    }

    @Override
    public float getGyroscopeX() {
        return 0.0f;
    }

    @Override
    public float getGyroscopeY() {
        return 0.0f;
    }

    @Override
    public float getGyroscopeZ() {
        return 0.0f;
    }

    protected int getGdxKeyCode(UIKey key) {
        UIKeyboardHIDUsage keyCode;
        try {
            keyCode = key.getKeyCode();
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
        switch (keyCode) {
            case KeyboardA: {
                return 29;
            }
            case KeyboardB: {
                return 30;
            }
            case KeyboardC: {
                return 31;
            }
            case KeyboardD: {
                return 32;
            }
            case KeyboardE: {
                return 33;
            }
            case KeyboardF: {
                return 34;
            }
            case KeyboardG: {
                return 35;
            }
            case KeyboardH: {
                return 36;
            }
            case KeyboardI: {
                return 37;
            }
            case KeyboardJ: {
                return 38;
            }
            case KeyboardK: {
                return 39;
            }
            case KeyboardL: {
                return 40;
            }
            case KeyboardM: {
                return 41;
            }
            case KeyboardN: {
                return 42;
            }
            case KeyboardO: {
                return 43;
            }
            case KeyboardP: {
                return 44;
            }
            case KeyboardQ: {
                return 45;
            }
            case KeyboardR: {
                return 46;
            }
            case KeyboardS: {
                return 47;
            }
            case KeyboardT: {
                return 48;
            }
            case KeyboardU: {
                return 49;
            }
            case KeyboardV: {
                return 50;
            }
            case KeyboardW: {
                return 51;
            }
            case KeyboardX: {
                return 52;
            }
            case KeyboardY: {
                return 53;
            }
            case KeyboardZ: {
                return 54;
            }
            case Keyboard1: {
                return 8;
            }
            case Keyboard2: {
                return 9;
            }
            case Keyboard3: {
                return 10;
            }
            case Keyboard4: {
                return 11;
            }
            case Keyboard5: {
                return 12;
            }
            case Keyboard6: {
                return 13;
            }
            case Keyboard7: {
                return 14;
            }
            case Keyboard8: {
                return 15;
            }
            case Keyboard9: {
                return 16;
            }
            case Keyboard0: {
                return 7;
            }
            case KeyboardReturnOrEnter: {
                return 66;
            }
            case KeyboardEscape: {
                return 111;
            }
            case KeyboardDeleteOrBackspace: {
                return 67;
            }
            case KeyboardTab: {
                return 61;
            }
            case KeyboardSpacebar: {
                return 62;
            }
            case KeyboardHyphen: {
                return 69;
            }
            case KeyboardEqualSign: {
                return 70;
            }
            case KeyboardOpenBracket: {
                return 71;
            }
            case KeyboardCloseBracket: {
                return 72;
            }
            case KeyboardBackslash: {
                return 73;
            }
            case KeyboardNonUSPound: {
                return 18;
            }
            case KeyboardSemicolon: {
                return 74;
            }
            case KeyboardQuote: {
                return 75;
            }
            case KeyboardGraveAccentAndTilde: {
                return 68;
            }
            case KeyboardComma: {
                return 55;
            }
            case KeyboardPeriod: {
                return 56;
            }
            case KeyboardSlash: {
                return 76;
            }
            case KeyboardF1: {
                return 131;
            }
            case KeyboardF2: {
                return 132;
            }
            case KeyboardF3: {
                return 133;
            }
            case KeyboardF4: {
                return 134;
            }
            case KeyboardF5: {
                return 135;
            }
            case KeyboardF6: {
                return 136;
            }
            case KeyboardF7: {
                return 137;
            }
            case KeyboardF8: {
                return 138;
            }
            case KeyboardF9: {
                return 139;
            }
            case KeyboardF10: {
                return 140;
            }
            case KeyboardF11: {
                return 141;
            }
            case KeyboardF12: {
                return 142;
            }
            case KeyboardF13: {
                return 183;
            }
            case KeyboardF14: {
                return 184;
            }
            case KeyboardF15: {
                return 185;
            }
            case KeyboardF16: {
                return 186;
            }
            case KeyboardF17: {
                return 187;
            }
            case KeyboardF18: {
                return 188;
            }
            case KeyboardF19: {
                return 189;
            }
            case KeyboardF20: {
                return 190;
            }
            case KeyboardF21: {
                return 191;
            }
            case KeyboardF22: {
                return 192;
            }
            case KeyboardF23: {
                return 193;
            }
            case KeyboardF24: {
                return 194;
            }
            case KeyboardPause: {
                return 121;
            }
            case KeyboardInsert: {
                return 124;
            }
            case KeyboardHome: {
                return 3;
            }
            case KeyboardPageUp: {
                return 92;
            }
            case KeyboardDeleteForward: {
                return 112;
            }
            case KeyboardEnd: {
                return 123;
            }
            case KeyboardPageDown: {
                return 93;
            }
            case KeyboardRightArrow: {
                return 22;
            }
            case KeyboardLeftArrow: {
                return 21;
            }
            case KeyboardDownArrow: {
                return 20;
            }
            case KeyboardUpArrow: {
                return 19;
            }
            case KeypadNumLock: {
                return 143;
            }
            case KeypadSlash: {
                return 154;
            }
            case KeypadAsterisk: {
                return 155;
            }
            case KeypadHyphen: {
                return 156;
            }
            case KeypadPlus: {
                return 157;
            }
            case KeypadEnter: {
                return 160;
            }
            case Keypad1: {
                return 8;
            }
            case Keypad2: {
                return 9;
            }
            case Keypad3: {
                return 10;
            }
            case Keypad4: {
                return 11;
            }
            case Keypad5: {
                return 12;
            }
            case Keypad6: {
                return 13;
            }
            case Keypad7: {
                return 14;
            }
            case Keypad8: {
                return 15;
            }
            case Keypad9: {
                return 16;
            }
            case Keypad0: {
                return 7;
            }
            case KeypadPeriod: {
                return 158;
            }
            case KeyboardNonUSBackslash: {
                return 73;
            }
            case KeyboardApplication: {
                return 82;
            }
            case KeyboardPower: {
                return 26;
            }
            case KeypadEqualSign: 
            case KeypadEqualSignAS400: {
                return 161;
            }
            case KeyboardHelp: {
                return 131;
            }
            case KeyboardMenu: {
                return 82;
            }
            case KeyboardSelect: {
                return 109;
            }
            case KeyboardStop: {
                return 86;
            }
            case KeyboardFind: {
                return 84;
            }
            case KeyboardMute: {
                return 91;
            }
            case KeyboardVolumeUp: {
                return 24;
            }
            case KeyboardVolumeDown: {
                return 25;
            }
            case KeypadComma: {
                return 159;
            }
            case KeyboardAlternateErase: {
                return 67;
            }
            case KeyboardCancel: {
                return 111;
            }
            case KeyboardClear: {
                return 28;
            }
            case KeyboardReturn: {
                return 66;
            }
            case KeyboardLeftControl: {
                return 129;
            }
            case KeyboardLeftShift: {
                return 59;
            }
            case KeyboardLeftAlt: {
                return 57;
            }
            case KeyboardRightControl: {
                return 130;
            }
            case KeyboardRightShift: {
                return 60;
            }
            case KeyboardRightAlt: {
                return 58;
            }
            case KeyboardCapsLock: {
                return 115;
            }
            case KeyboardPrintScreen: {
                return 120;
            }
            case KeyboardScrollLock: {
                return 116;
            }
        }
        return 0;
    }

    static class KeyEvent {
        static final int KEY_DOWN = 0;
        static final int KEY_UP = 1;
        static final int KEY_TYPED = 2;
        long timeStamp;
        int type;
        int keyCode;
        char keyChar;

        KeyEvent() {
        }
    }

    static class TouchEvent {
        UITouchPhase phase;
        long timestamp;
        int x;
        int y;
        int pointer;

        TouchEvent() {
        }
    }

    private static class NSArrayExtensions
    extends NSExtensions {
        private NSArrayExtensions() {
        }

        @Method(selector="objectAtIndex:")
        @Pointer
        public static native long objectAtIndex$(@Pointer long var0, @MachineSizedUInt long var2);

        @Method(selector="count")
        @MachineSizedUInt
        public static native long count(@Pointer long var0);
    }

    private static class NSSetExtensions
    extends NSExtensions {
        private NSSetExtensions() {
        }

        @Method(selector="allObjects")
        @Pointer
        public static native long allObjects(@Pointer long var0);
    }

    private static class NSObjectWrapper<T extends NSObject> {
        private static final long HANDLE_OFFSET;
        private final T instance;

        public NSObjectWrapper(Class<T> cls) {
            this.instance = (NSObject)VM.allocateObject(cls);
        }

        public T wrap(long handle) {
            VM.setLong((long)(VM.getObjectAddress(this.instance) + HANDLE_OFFSET), (long)handle);
            return this.instance;
        }

        static {
            try {
                HANDLE_OFFSET = VM.getInstanceFieldOffset((long)VM.getFieldAddress((Field)NativeObject.class.getDeclaredField("handle")));
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }
    }
}

