/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.message.DOMMessage;
import com.sun.xml.internal.ws.message.EmptyMessageImpl;
import com.sun.xml.internal.ws.message.jaxb.JAXBMessage;
import com.sun.xml.internal.ws.message.source.PayloadSourceMessage;
import com.sun.xml.internal.ws.spi.db.BindingContext;
import com.sun.xml.internal.ws.spi.db.BindingContextFactory;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class LogicalMessageImpl
implements LogicalMessage {
    private Packet packet;
    protected BindingContext defaultJaxbContext;
    private ImmutableLM lm = null;

    public LogicalMessageImpl(BindingContext bindingContext, Packet packet) {
        this.packet = packet;
        this.defaultJaxbContext = bindingContext;
    }

    @Override
    public Source getPayload() {
        if (this.lm == null) {
            Source source = this.packet.getMessage().copy().readPayloadAsSource();
            if (source instanceof DOMSource) {
                this.lm = this.createLogicalMessageImpl(source);
            }
            return source;
        }
        return this.lm.getPayload();
    }

    @Override
    public void setPayload(Source source) {
        this.lm = this.createLogicalMessageImpl(source);
    }

    private ImmutableLM createLogicalMessageImpl(Source source) {
        this.lm = source == null ? new EmptyLogicalMessageImpl() : (source instanceof DOMSource ? new DOMLogicalMessageImpl((DOMSource)source) : new SourceLogicalMessageImpl(source));
        return this.lm;
    }

    public Object getPayload(BindingContext bindingContext) {
        Object object;
        if (bindingContext == null) {
            bindingContext = this.defaultJaxbContext;
        }
        if (bindingContext == null) {
            throw new WebServiceException("JAXBContext parameter cannot be null");
        }
        if (this.lm == null) {
            try {
                object = this.packet.getMessage().copy().readPayloadAsJAXB(bindingContext.createUnmarshaller());
            }
            catch (JAXBException jAXBException) {
                throw new WebServiceException(jAXBException);
            }
        } else {
            object = this.lm.getPayload(bindingContext);
            this.lm = new JAXBLogicalMessageImpl(bindingContext.getJAXBContext(), object);
        }
        return object;
    }

    @Override
    public Object getPayload(JAXBContext jAXBContext) {
        Object object;
        if (jAXBContext == null) {
            return this.getPayload(this.defaultJaxbContext);
        }
        if (jAXBContext == null) {
            throw new WebServiceException("JAXBContext parameter cannot be null");
        }
        if (this.lm == null) {
            try {
                object = this.packet.getMessage().copy().readPayloadAsJAXB(jAXBContext.createUnmarshaller());
            }
            catch (JAXBException jAXBException) {
                throw new WebServiceException(jAXBException);
            }
        } else {
            object = this.lm.getPayload(jAXBContext);
            this.lm = new JAXBLogicalMessageImpl(jAXBContext, object);
        }
        return object;
    }

    public void setPayload(Object object, BindingContext bindingContext) {
        if (bindingContext == null) {
            bindingContext = this.defaultJaxbContext;
        }
        this.lm = object == null ? new EmptyLogicalMessageImpl() : new JAXBLogicalMessageImpl(bindingContext.getJAXBContext(), object);
    }

    @Override
    public void setPayload(Object object, JAXBContext jAXBContext) {
        if (jAXBContext == null) {
            this.setPayload(object, this.defaultJaxbContext);
        }
        this.lm = object == null ? new EmptyLogicalMessageImpl() : new JAXBLogicalMessageImpl(jAXBContext, object);
    }

    public boolean isPayloadModifed() {
        return this.lm != null;
    }

    public Message getMessage(MessageHeaders messageHeaders, AttachmentSet attachmentSet, WSBinding wSBinding) {
        assert (this.isPayloadModifed());
        if (this.isPayloadModifed()) {
            return this.lm.getMessage(messageHeaders, attachmentSet, wSBinding);
        }
        return this.packet.getMessage();
    }

    private class DOMLogicalMessageImpl
    extends SourceLogicalMessageImpl {
        private DOMSource dom;

        public DOMLogicalMessageImpl(DOMSource dOMSource) {
            super(dOMSource);
            this.dom = dOMSource;
        }

        @Override
        public Source getPayload() {
            return this.dom;
        }

        @Override
        public Message getMessage(MessageHeaders messageHeaders, AttachmentSet attachmentSet, WSBinding wSBinding) {
            Node node = this.dom.getNode();
            if (node.getNodeType() == 9) {
                node = ((Document)node).getDocumentElement();
            }
            return new DOMMessage(wSBinding.getSOAPVersion(), messageHeaders, (Element)node, attachmentSet);
        }
    }

    private class EmptyLogicalMessageImpl
    extends ImmutableLM {
        @Override
        public Source getPayload() {
            return null;
        }

        @Override
        public Object getPayload(JAXBContext jAXBContext) {
            return null;
        }

        @Override
        public Object getPayload(BindingContext bindingContext) {
            return null;
        }

        @Override
        public Message getMessage(MessageHeaders messageHeaders, AttachmentSet attachmentSet, WSBinding wSBinding) {
            return new EmptyMessageImpl(messageHeaders, attachmentSet, wSBinding.getSOAPVersion());
        }
    }

    private abstract class ImmutableLM {
        private ImmutableLM() {
        }

        public abstract Source getPayload();

        public abstract Object getPayload(BindingContext var1);

        public abstract Object getPayload(JAXBContext var1);

        public abstract Message getMessage(MessageHeaders var1, AttachmentSet var2, WSBinding var3);
    }

    private class JAXBLogicalMessageImpl
    extends ImmutableLM {
        private JAXBContext ctxt;
        private Object o;

        public JAXBLogicalMessageImpl(JAXBContext jAXBContext, Object object) {
            this.ctxt = jAXBContext;
            this.o = object;
        }

        @Override
        public Source getPayload() {
            JAXBContext jAXBContext = this.ctxt;
            if (jAXBContext == null) {
                jAXBContext = LogicalMessageImpl.this.defaultJaxbContext.getJAXBContext();
            }
            try {
                return new JAXBSource(jAXBContext, this.o);
            }
            catch (JAXBException jAXBException) {
                throw new WebServiceException(jAXBException);
            }
        }

        @Override
        public Object getPayload(JAXBContext jAXBContext) {
            try {
                Source source = this.getPayload();
                if (source == null) {
                    return null;
                }
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                return unmarshaller.unmarshal(source);
            }
            catch (JAXBException jAXBException) {
                throw new WebServiceException(jAXBException);
            }
        }

        @Override
        public Object getPayload(BindingContext bindingContext) {
            try {
                Source source = this.getPayload();
                if (source == null) {
                    return null;
                }
                Unmarshaller unmarshaller = bindingContext.createUnmarshaller();
                return unmarshaller.unmarshal(source);
            }
            catch (JAXBException jAXBException) {
                throw new WebServiceException(jAXBException);
            }
        }

        @Override
        public Message getMessage(MessageHeaders messageHeaders, AttachmentSet attachmentSet, WSBinding wSBinding) {
            return JAXBMessage.create(BindingContextFactory.create(this.ctxt), this.o, wSBinding.getSOAPVersion(), messageHeaders, attachmentSet);
        }
    }

    private class SourceLogicalMessageImpl
    extends ImmutableLM {
        private Source payloadSrc;

        public SourceLogicalMessageImpl(Source source) {
            this.payloadSrc = source;
        }

        @Override
        public Source getPayload() {
            assert (!(this.payloadSrc instanceof DOMSource));
            try {
                Transformer transformer = XmlUtil.newTransformer();
                DOMResult dOMResult = new DOMResult();
                transformer.transform(this.payloadSrc, dOMResult);
                DOMSource dOMSource = new DOMSource(dOMResult.getNode());
                LogicalMessageImpl.this.lm = new DOMLogicalMessageImpl(dOMSource);
                this.payloadSrc = null;
                return dOMSource;
            }
            catch (TransformerException transformerException) {
                throw new WebServiceException(transformerException);
            }
        }

        @Override
        public Object getPayload(JAXBContext jAXBContext) {
            try {
                Source source = this.getPayload();
                if (source == null) {
                    return null;
                }
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                return unmarshaller.unmarshal(source);
            }
            catch (JAXBException jAXBException) {
                throw new WebServiceException(jAXBException);
            }
        }

        @Override
        public Object getPayload(BindingContext bindingContext) {
            try {
                Source source = this.getPayload();
                if (source == null) {
                    return null;
                }
                Unmarshaller unmarshaller = bindingContext.createUnmarshaller();
                return unmarshaller.unmarshal(source);
            }
            catch (JAXBException jAXBException) {
                throw new WebServiceException(jAXBException);
            }
        }

        @Override
        public Message getMessage(MessageHeaders messageHeaders, AttachmentSet attachmentSet, WSBinding wSBinding) {
            assert (this.payloadSrc != null);
            return new PayloadSourceMessage(messageHeaders, this.payloadSrc, attachmentSet, wSBinding.getSOAPVersion());
        }
    }
}

