/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.handler.HandlerProcessor;
import com.sun.xml.internal.ws.handler.HandlerTube;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import com.sun.xml.internal.ws.handler.SOAPHandlerProcessor;
import com.sun.xml.internal.ws.handler.SOAPMessageContextImpl;
import com.sun.xml.internal.ws.message.DataHandlerAttachment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;

public class ClientSOAPHandlerTube
extends HandlerTube {
    private Set<String> roles;

    public ClientSOAPHandlerTube(WSBinding wSBinding, WSDLPort wSDLPort, Tube tube) {
        super(tube, wSDLPort, wSBinding);
        if (wSBinding.getSOAPVersion() != null) {
            // empty if block
        }
    }

    public ClientSOAPHandlerTube(WSBinding wSBinding, Tube tube, HandlerTube handlerTube) {
        super(tube, handlerTube, wSBinding);
    }

    private ClientSOAPHandlerTube(ClientSOAPHandlerTube clientSOAPHandlerTube, TubeCloner tubeCloner) {
        super(clientSOAPHandlerTube, tubeCloner);
    }

    @Override
    public AbstractFilterTubeImpl copy(TubeCloner tubeCloner) {
        return new ClientSOAPHandlerTube(this, tubeCloner);
    }

    @Override
    void setUpProcessor() {
        if (this.handlers == null) {
            this.handlers = new ArrayList();
            HandlerConfiguration handlerConfiguration = ((BindingImpl)this.getBinding()).getHandlerConfig();
            List<SOAPHandler> list = handlerConfiguration.getSoapHandlers();
            if (!list.isEmpty()) {
                this.handlers.addAll(list);
                this.roles = new HashSet<String>();
                this.roles.addAll(handlerConfiguration.getRoles());
                this.processor = new SOAPHandlerProcessor(true, this, this.getBinding(), this.handlers);
            }
        }
    }

    @Override
    MessageUpdatableContext getContext(Packet packet) {
        SOAPMessageContextImpl sOAPMessageContextImpl = new SOAPMessageContextImpl(this.getBinding(), packet, this.roles);
        return sOAPMessageContextImpl;
    }

    @Override
    boolean callHandlersOnRequest(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        boolean bl2;
        Map map = (Map)messageUpdatableContext.get("javax.xml.ws.binding.attachments.outbound");
        AttachmentSet attachmentSet = messageUpdatableContext.packet.getMessage().getAttachments();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            if (attachmentSet.get(string) != null) continue;
            DataHandlerAttachment dataHandlerAttachment = new DataHandlerAttachment(string, (DataHandler)map.get(string));
            attachmentSet.add(dataHandlerAttachment);
        }
        try {
            bl2 = this.processor.callHandlersRequest(HandlerProcessor.Direction.OUTBOUND, messageUpdatableContext, !bl);
        }
        catch (WebServiceException webServiceException) {
            this.remedyActionTaken = true;
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            this.remedyActionTaken = true;
            throw new WebServiceException(runtimeException);
        }
        if (!bl2) {
            this.remedyActionTaken = true;
        }
        return bl2;
    }

    @Override
    void callHandlersOnResponse(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        try {
            this.processor.callHandlersResponse(HandlerProcessor.Direction.INBOUND, messageUpdatableContext, bl);
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            throw new WebServiceException(runtimeException);
        }
    }

    @Override
    void closeHandlers(MessageContext messageContext) {
        this.closeClientsideHandlers(messageContext);
    }
}

