/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.sei;

import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.client.sei.BodyBuilder;
import com.sun.xml.internal.ws.client.sei.MessageFiller;
import com.sun.xml.internal.ws.client.sei.MethodHandler;
import com.sun.xml.internal.ws.client.sei.ResponseBuilder;
import com.sun.xml.internal.ws.client.sei.SEIStub;
import com.sun.xml.internal.ws.client.sei.ValueGetter;
import com.sun.xml.internal.ws.client.sei.ValueGetterFactory;
import com.sun.xml.internal.ws.client.sei.ValueSetter;
import com.sun.xml.internal.ws.client.sei.ValueSetterFactory;
import com.sun.xml.internal.ws.model.CheckedExceptionImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

abstract class SEIMethodHandler
extends MethodHandler {
    private BodyBuilder bodyBuilder;
    private MessageFiller[] inFillers;
    protected String soapAction;
    protected boolean isOneWay;
    protected JavaMethodImpl javaMethod;
    protected Map<QName, CheckedExceptionImpl> checkedExceptions;

    SEIMethodHandler(SEIStub sEIStub) {
        super(sEIStub, null);
    }

    /*
     * WARNING - void declaration
     */
    SEIMethodHandler(SEIStub sEIStub, JavaMethodImpl javaMethodImpl) {
        super(sEIStub, null);
        void var4_12;
        void var4_6;
        this.checkedExceptions = new HashMap<QName, CheckedExceptionImpl>();
        for (CheckedExceptionImpl object2 : javaMethodImpl.getCheckedExceptions()) {
            this.checkedExceptions.put(object2.getBond().getTypeInfo().tagName, object2);
        }
        this.soapAction = javaMethodImpl.getInputAction() != null && !javaMethodImpl.getBinding().getSOAPAction().equals("") ? javaMethodImpl.getInputAction() : javaMethodImpl.getBinding().getSOAPAction();
        this.javaMethod = javaMethodImpl;
        List<ParameterImpl> list = javaMethodImpl.getRequestParameters();
        Object var4_5 = null;
        ArrayList<MessageFiller> arrayList = new ArrayList<MessageFiller>();
        Iterator iterator = list.iterator();
        block11: while (iterator.hasNext()) {
            ParameterImpl parameterImpl = (ParameterImpl)iterator.next();
            ValueGetter valueGetter = this.getValueGetterFactory().get(parameterImpl);
            switch (parameterImpl.getInBinding().kind) {
                case BODY: {
                    if (parameterImpl.isWrapperStyle()) {
                        if (parameterImpl.getParent().getBinding().isRpcLit()) {
                            BodyBuilder.RpcLit rpcLit = new BodyBuilder.RpcLit((WrapperParameter)parameterImpl, sEIStub.soapVersion, this.getValueGetterFactory());
                            continue block11;
                        }
                        BodyBuilder.DocLit docLit = new BodyBuilder.DocLit((WrapperParameter)parameterImpl, sEIStub.soapVersion, this.getValueGetterFactory());
                        continue block11;
                    }
                    BodyBuilder.Bare bare = new BodyBuilder.Bare(parameterImpl, sEIStub.soapVersion, valueGetter);
                    continue block11;
                }
                case HEADER: {
                    arrayList.add(new MessageFiller.Header(parameterImpl.getIndex(), parameterImpl.getXMLBridge(), valueGetter));
                    continue block11;
                }
                case ATTACHMENT: {
                    arrayList.add(MessageFiller.AttachmentFiller.createAttachmentFiller(parameterImpl, valueGetter));
                    continue block11;
                }
                case UNBOUND: {
                    continue block11;
                }
            }
            throw new AssertionError();
        }
        if (var4_6 == null) {
            switch (sEIStub.soapVersion) {
                case SOAP_11: {
                    BodyBuilder bodyBuilder = BodyBuilder.EMPTY_SOAP11;
                    break;
                }
                case SOAP_12: {
                    BodyBuilder bodyBuilder = BodyBuilder.EMPTY_SOAP12;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.bodyBuilder = var4_12;
        this.inFillers = arrayList.toArray(new MessageFiller[arrayList.size()]);
        this.isOneWay = javaMethodImpl.getMEP().isOneWay();
    }

    ResponseBuilder buildResponseBuilder(JavaMethodImpl javaMethodImpl, ValueSetterFactory valueSetterFactory) {
        Object object;
        List<ParameterImpl> list = javaMethodImpl.getResponseParameters();
        ArrayList<ResponseBuilder> arrayList = new ArrayList<ResponseBuilder>();
        block10: for (ParameterImpl parameterImpl : list) {
            switch (parameterImpl.getOutBinding().kind) {
                case BODY: {
                    if (parameterImpl.isWrapperStyle()) {
                        if (parameterImpl.getParent().getBinding().isRpcLit()) {
                            arrayList.add(new ResponseBuilder.RpcLit((WrapperParameter)parameterImpl, valueSetterFactory));
                            continue block10;
                        }
                        arrayList.add(new ResponseBuilder.DocLit((WrapperParameter)parameterImpl, valueSetterFactory));
                        continue block10;
                    }
                    ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                    arrayList.add(new ResponseBuilder.Body(parameterImpl.getXMLBridge(), valueSetter));
                    continue block10;
                }
                case HEADER: {
                    ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                    arrayList.add(new ResponseBuilder.Header(this.owner.soapVersion, parameterImpl, valueSetter));
                    continue block10;
                }
                case ATTACHMENT: {
                    ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                    arrayList.add(ResponseBuilder.AttachmentBuilder.createAttachmentBuilder(parameterImpl, valueSetter));
                    continue block10;
                }
                case UNBOUND: {
                    ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                    arrayList.add(new ResponseBuilder.NullSetter(valueSetter, ResponseBuilder.getVMUninitializedValue(parameterImpl.getTypeInfo().type)));
                    continue block10;
                }
            }
            throw new AssertionError();
        }
        switch (arrayList.size()) {
            case 0: {
                object = ResponseBuilder.NONE;
                break;
            }
            case 1: {
                object = (ResponseBuilder)arrayList.get(0);
                break;
            }
            default: {
                object = new ResponseBuilder.Composite(arrayList);
            }
        }
        return object;
    }

    Message createRequestMessage(Object[] objectArray) {
        Message message = this.bodyBuilder.createMessage(objectArray);
        for (MessageFiller messageFiller : this.inFillers) {
            messageFiller.fillIn(objectArray, message);
        }
        return message;
    }

    abstract ValueGetterFactory getValueGetterFactory();
}

