/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.server;

import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import java.util.concurrent.Executor;

public class ThreadLocalContainerResolver
extends ContainerResolver {
    private ThreadLocal<Container> containerThreadLocal = new ThreadLocal<Container>(){

        @Override
        protected Container initialValue() {
            return Container.NONE;
        }
    };

    @Override
    public Container getContainer() {
        return this.containerThreadLocal.get();
    }

    public Container enterContainer(Container container) {
        Container container2 = this.containerThreadLocal.get();
        this.containerThreadLocal.set(container);
        return container2;
    }

    public void exitContainer(Container container) {
        this.containerThreadLocal.set(container);
    }

    public Executor wrapExecutor(final Container container, final Executor executor) {
        if (executor == null) {
            return null;
        }
        return new Executor(){

            @Override
            public void execute(final Runnable runnable) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Container container = ThreadLocalContainerResolver.this.enterContainer(container);
                        try {
                            runnable.run();
                        }
                        finally {
                            ThreadLocalContainerResolver.this.exitContainer(container);
                        }
                    }
                });
            }
        };
    }
}

